#include "dialog.h"
#include "game.h"
#define say_(W, H, T, BUBBLE) \
    if (game->dialog.H == W) { \
        b->text = T; \
        b->thought = BUBBLE; \
    }
#define speak_(W, H, T) \
    if (game->dialog.H == W) { \
        if (game->T) { \
            game->T->talk = 1; \
        } \
    }
#define say(W, T) \
    say_(W, orchid, T, 0);
#define think(W, T) \
    say_(W, orchid, T, 1);
#define speak(W, T) \
    speak_(W, orchid, T);
void dialog_herbalist(Block * b) {
    if (b->talk) {
        b->speech++;
        think(0, "What is this odor?");
        say(1, "On the other side\nof this moor");
        say(2, "there's a\nmagical flower");
        say(3, "that will give you\ngreat beauty");
        say(4, "Just walk along\nthe boardwalk!");
        say(5, "Hey there!");
        say(12, "Haha you fell for it!");
        say(13, "No, you learned\na valuable lesson.");
        say(14, "Perhaps!");
        if (! b->text) {
            b->speech = 0;
            b->talk = 0;
            return ;
        }
        if (b->speech >= 60 * 3) {
            b->speech = 0;
            b->talk = 0;
            speak(0, skunk);
            speak(1, orchid);
            speak(2, orchid);
            speak(3, skunk);
            speak(12, elephant);
            speak(13, skunk);
            speak(14, elephant);
            if (game->dialog.skunk < 4) {
                speak(4, skunk);
            }
            if (game->dialog.orchid == 4 || game->dialog.orchid == 5) {
                if (game->elephant && game->level == 27) {
                    game->orchid->y = - 9000;
                    game->dialog.orchid = 5;
                }
            }
            else {
                game->dialog.orchid++;
            }
        }
    }
}
#undef say
#undef think
#undef speak
#define say(W, T) \
    say_(W, skunk, T, 0);
#define think(W, T) \
    say_(W, skunk, T, 1);
#define speak(W, T) \
    speak_(W, skunk, T);
void dialog_skunk(Block * b) {
    if (b->talk) {
        b->speech++;
        say(0, "Sorry! I'm a skunk.");
        say(1, "But how do I get there?");
        think(2, "I'm too scared\nto walk there alone");
        think(3, "but I know\nsomeone big and\nstrong to help.");
        say(4, "Oh mighty elephant!\nI have discovered");
        say(5, "a magical flower\non the other side\nof the moor");
        say(6, "It possesses\nincredible powers that can\nmake you");
        say(7, "even more majestic\nand admired by\nall creatures!");
        say(8, "if you follow me,\nI shall lead you to this\nextraordinary flower.");
        say(10, "Where is the flower?");
        say(11, "The beautiful gnome?");
        say(12, "I'm a skunk. We want the flower.");
        say(13, "What about the\nmarvellous flower with\nmagic powers?");
        say(14, "Never to believe\na mysterious stranger?");
        say(15, "Ice cream is\nalways a good idea.\nLet's go!");
        if (b->speech >= 60 * 3) {
            b->speech = 0;
            b->talk = 0;
            if (game->dialog.skunk < 4) {
                speak(0, orchid);
                speak(1, orchid);
            }
            speak(2, skunk);
            speak(4, skunk);
            speak(5, skunk);
            speak(6, skunk);
            speak(7, elephant);
            speak(8, elephant);
            speak(10, gnome);
            speak(11, gnome);
            speak(12, gnome);
            speak(12, elephant);
            speak(13, orchid);
            speak(14, orchid);
            game->dialog.skunk++;
        }
    }
}
#undef say
#undef think
#undef speak
#define say(W, T) \
    say_(W, elephant, T, 0);
#define think(W, T) \
    say_(W, elephant, T, 1);
#define speak(W, T) \
    speak_(W, elephant, T);
void dialog_elephant(Block * b) {
    if (b->talk) {
        b->speech++;
        if (b->interject) {
            b->text = b->interject;
        }
        else {
            say(0, "Hey watch it!");
            think(1, "Intriguing!");
            say(2, "I shall\naccompany you\non this journey!");
            say(10, "What chart?");
            say(12, "I'm an elephant!");
            say(13, "Is that why you're so colorful?");
            say(14, "What? All this was for nothing?");
            say(15, "Let's go home\nand eat ice cream!");
        }
        if (b->speech >= 60 * 3) {
            b->speech = 0;
            b->talk = 0;
            if (b->interject) {
                b->interject = NULL;
            }
            else {
                if (game->dialog.skunk > 3) {
                    speak(0, skunk);
                    speak(1, skunk);
                    speak(13, gnome);
                    speak(14, orchid);
                    speak(15, skunk);
                    game->dialog.elephant++;
                }
            }
        }
    }
}
#undef say
#undef think
#undef speak
#define say(W, T) \
    say_(W, gnome, T, 0);
#define think(W, T) \
    say_(W, gnome, T, 1);
#define speak(W, T) \
    speak_(W, gnome, T);
void dialog_gnome(Block * b) {
    if (b->talk) {
        b->speech++;
        say(0, "Welcome...\nother side...\nmoor...");
        say(1, "We pick flower...\ngive beautiful...\ngnome...");
        say(2, "find gnome... look chart...");
        say(10, "Hi I'm Candy!");
        say(11, "I ate the flower!");
        say(12, "No, all gnomes eat flowers");
    }
    if (b->speech >= 60 * 3) {
        b->speech = 0;
        b->talk = 0;
        if (game->dialog.gnome == 0) {
            game->dialog.skunk = 10;
            game->dialog.elephant = 10;
        }
        if (game->dialog.gnome == 10) {
            game->dialog.skunk = 12;
            game->dialog.elephant = 12;
        }
        if (game->dialog.gnome == 12) {
            game->dialog.orchid = 12;
        }
        speak(0, skunk);
        speak(1, skunk);
        speak(2, elephant);
        speak(10, skunk);
        speak(10, elephant);
        speak(11, elephant);
        speak(12, skunk);
        game->dialog.gnome++;
    }
}
#undef say
#undef think
#undef speak
#define say(W, T) \
    say_(W, chameleon, T, 0);
#define think(W, T) \
    say_(W, chameleon, T, 1);
#define speak(W, T) \
    speak_(W, chameleon, T);
void dialog_chameleon(Block * b) {
    if (b->talk) {
        b->speech++;
        say(0, "The flower is a lie");
    }
    if (b->speech >= 60 * 3) {
        b->speech = 0;
        b->talk = 0;
    }
}
